<?php

namespace App\Http\Controllers;

use App\Models\Mark;
use App\Models\MarkProduct;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use Illuminate\Http\Request;
use Illuminate\Database\QueryException;
use App\Http\Requests\MarkRequest;
use App\Http\Requests\MarkAddRequest;
use Illuminate\Support\Facades\DB;

use Illuminate\Support\Facades\Config;

class MarkController extends Controller
{
    public function index(Mark $mark)
    {
        try {
            $mark = $mark->where('deleted', false)->get();
            return response()->json($mark, 201);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Nenhuma marca foi encontrada.'], 404);
        }
    }



    public function show($id)
    {
        try {

            $mark = Mark::findOrFail($id);

            return response()->json($mark, 201);
        } catch (QueryException $e) {
            return response()->json(['error' => 'Erro no banco de dados: ' . $e->getMessage()], 500);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Marca não encontrada.'], 404);
        }
    }

    public function create(MarkRequest $request)
    {
        try {
            $validatedData = $request->validated();

            // Ajusta o banco em tempo real
            Config::set('database.connections.mysql.database', 'sunstone_loja3');

            // Define dinamicamente o DB
            config([
                'database.connections.mysql.database' => 'sunstone_loja3',
            ]);

            // Reinicia a conexão
            DB::purge('mysql');
            DB::reconnect('mysql');



            $mark = Mark::create($validatedData);

            return response()->json([
                'message' => 'Marca criada com sucesso.',
                'data' => $mark
            ], 201);
        } catch (QueryException $e) {
            return response()->json([
                'error' => 'Erro no banco de dados: ' . $e->getMessage()
            ], 500);
        } catch (\Illuminate\Validation\ValidationException $e) {
            return response()->json([
                'error' => 'Erro de validação',
                'messages' => $e->errors()
            ], 422);
        } catch (\Exception $e) {
            return response()->json([
                'error' => 'Erro: ' . $e->getMessage()
            ], 500);
        }
    }


    public function update(MarkRequest $request, $id)
    {
        try {
            $validatedData = $request->validated();

            $mark = Mark::findOrFail($id);
            $mark->update($validatedData);

            return response()->json([
                'message' => 'Marca atualizada com sucesso.',
                'data' => $mark
            ], 201);
        } catch (QueryException $e) {
            return response()->json([
                'error' => 'Erro no banco de dados: ' . $e->getMessage()
            ], 500);
        } catch (\Illuminate\Validation\ValidationException $e) {
            return response()->json([
                'error' => 'Erro de validação',
                'messages' => $e->errors()
            ], 422);
        } catch (\Exception $e) {
            return response()->json([
                'error' => 'Erro: ' . $e->getMessage()
            ], 500);
        }
    }

    public function destroy($id)
    {
        try {
            $mark = Mark::findOrFail($id);
            $mark->update(['deleted' => 1]);

            return response()->json(['message' => 'Marca excluída com sucesso.'], 204);
        } catch (QueryException $e) {
            return response()->json([
                'error' => 'Erro no banco de dados: ' . $e->getMessage()
            ], 500);
        } catch (\Exception $e) {
            return response()->json([
                'error' => 'Erro: ' . $e->getMessage()
            ], 500);
        }
    }

    public function productMark(MarkAddRequest $request)
    {
        try {
            $validatedData = $request->validated();
            // Cria a associação entre a marca e o produto
            MarkProduct::create($validatedData);

            return response()->json([
                'message' => 'Produto adicionado à marca com sucesso!'
            ], 201);
        } catch (QueryException $e) {
            return response()->json([
                'error' => 'Erro no banco de dados: ' . $e->getMessage()
            ], 500);
        } catch (ModelNotFoundException $e) {
            return response()->json([
                'error' => 'Marca ou produto não encontrado.'
            ], 404);
        } catch (\Exception $e) {
            return response()->json([
                'error' => 'Erro: ' . $e->getMessage()
            ], 500);
        }
    }
}
