<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Pages;
use App\Http\Requests\PagesRequest;
use Illuminate\Database\QueryException;

class PagesController extends Controller
{
    // List all pages
    public function index()
    {
     
        try {
            $pages = Pages::where('deleted', false)
                ->where('type', 1)
                ->get();

            return response()->json($pages);
        } catch (\Exception $e) {
            return response()->json(['error' => 'Nenhuma página foi encontrada.'], 404);
        }
  
    }


    // Show a single page
    public function show($id)
    {
        try {

            $pages = Pages::where('deleted', false)
                ->where('id', $id)
                ->where('type', 1)
                ->get();
    
            if(count($pages) == 0){
                return response()->json(['error' => 'Página não encontrada.'], 404);
            }
    
              return response()->json($pages);
    
            } catch (QueryException $e) {
                return response()->json(['error' => 'Erro no banco de dados: ' . $e->getMessage()], 500);
    
            }  catch (\Exception $e) {
                return response()->json(['error' => 'Página não encontrada.'], 500);
            }
    }

   
   /**
     * Remove the specified page from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        try {
            $page = Pages::findOrFail($id);

            $page->update(['deleted'=>1]);

            return response()->json([
                'message' => 'Página deletada com sucesso.'
            ], 200);

        } catch (QueryException $e) {
            return response()->json([
                'error' => 'Erro no banco de dados: ' . $e->getMessage()
            ], 500);

        } catch (\Exception $e) {
            return response()->json([
                'error' => 'Erro: ' . $e->getMessage()
            ], 500);
        }
    }

    public function create(Request $request){
       

        try {
            // Validação dos dados
            $validatedData = $request->validate([
                'title' => 'required|string|max:255',
                'link' => 'required|string|max:500',
                'type' => 'required|in:1,2', // Supondo que os tipos válidos são '1' e '2'
                'content' => 'string',
                'deleted' => 'required|boolean',
            ]);

            // Criar nova página com os dados validados
            $page = Pages::create($validatedData);

            return response()->json([
                'message' => 'Página criada com sucesso.',
                'data' => $page
            ], 201);

        } catch (QueryException $e) {
            return response()->json([
                'error' => 'Erro no banco de dados: ' . $e->getMessage()
            ], 500);

        } catch (\Illuminate\Validation\ValidationException $e) {
            return response()->json([
                'error' => 'Erro de validação',
                'messages' => $e->errors()
            ], 422);

        } catch (\Exception $e) {
            return response()->json([
                'error' => 'Erro: ' . $e->getMessage()
            ], 500);
        }
        
    }


     /**
     * Update the specified page in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        try {
            // Validação dos dados
            $validatedData = $request->validate([
                'title' => 'required|string|max:255',
                'link' => 'required|string|max:500',
                'type' => 'required|in:1,2', // Supondo que os tipos válidos são '1' e '2'
                'content' => 'string',
                'deleted' => 'required|boolean',
            ]);

            // Encontrar a página pelo ID
            $page = Pages::findOrFail($id);

            // Atualizar os dados da página
            $page->update($validatedData);

            return response()->json([
                'message' => 'Página atualizada com sucesso.',
                'data' => $page
            ], 200);

        } catch (QueryException $e) {
            return response()->json([
                'error' => 'Erro no banco de dados: ' . $e->getMessage()
            ], 500);

        } catch (\Illuminate\Validation\ValidationException $e) {
            return response()->json([
                'error' => 'Erro de validação',
                'messages' => $e->errors()
            ], 422);

        } catch (\Exception $e) {
            return response()->json([
                'error' => 'Erro: ' . $e->getMessage()
            ], 500);
        }
    }
}




