<?php

namespace App\Exceptions;

use Illuminate\Foundation\Exceptions\Handler as ExceptionHandler;
use Throwable;

class Handler extends ExceptionHandler
{
    /**
     * The list of the inputs that are never flashed to the session on validation exceptions.
     *
     * @var array<int, string>
     */
    protected $dontFlash = [
        'current_password',
        'password',
        'password_confirmation',
    ];

    /**
     * Register the exception handling callbacks for the application.
     */
    public function register(): void
    {
        $this->reportable(function (Throwable $e) {
            //
        });
    }

    public function render($request, Throwable $exception)
{
    // Retorna JSON se for uma requisição para API
    if ($request->expectsJson()) {
        // Se quiser tratar exceções específicas, pode fazer aqui
        if ($exception instanceof AuthenticationException) {
            return response()->json([
                'message' => 'Não autenticado.'
            ], 401);
        }

        // Para outras exceções
        return response()->json([
            'message' => $exception->getMessage(),
        ], 500);
    }

    // Caso contrário, usa o comportamento padrão
    return parent::render($request, $exception);
}

}
